% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_ingest.R
\name{read_otel_json}
\alias{read_otel_json}
\title{Read OpenTelemetry JSON (OTLP) file}
\usage{
read_otel_json(path)
}
\arguments{
\item{path}{Path to OTLP JSON file}
}
\value{
Data frame with bidux event schema (converted from spans)
}
\description{
Reads OpenTelemetry Protocol (OTLP) JSON files containing span data from
Shiny 1.12+ applications. Extracts spans from the nested OTLP structure and
converts them to bidux event schema.
}
\examples{
\dontrun{
events <- read_otel_json("otel_spans.json")
names(events)
# [1] "timestamp" "session_id" "event_type" "input_id" "value" "error_message"
# [7] "output_id" "navigation_id"
}
}
\keyword{internal}
