% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_ingest.R
\name{check_json_depth}
\alias{check_json_depth}
\title{Check JSON nesting depth recursively}
\usage{
check_json_depth(obj, max_depth = 50, current_depth = 1)
}
\arguments{
\item{obj}{JSON object (list or other R object from \code{jsonlite::fromJSON})}

\item{max_depth}{Maximum allowed nesting depth (default: 50)}

\item{current_depth}{Current recursion depth (internal use)}
}
\value{
Logical \code{TRUE} if depth is acceptable, aborts with error if exceeded
}
\description{
Validates that JSON data does not exceed a maximum nesting depth to prevent
stack overflow and resource exhaustion attacks.
}
\keyword{internal}
