% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R, R/mock_bids.R
\name{surface_files}
\alias{surface_files}
\alias{surface_files.bids_project}
\alias{surface_files.mock_bids_project}
\title{Query Surface Files from a BIDS Project}
\usage{
surface_files(
  x,
  subid = ".*",
  session = ".*",
  hemi = ".*",
  surf_type = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)

\method{surface_files}{bids_project}(
  x,
  subid = ".*",
  session = ".*",
  hemi = ".*",
  surf_type = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)

\method{surface_files}{mock_bids_project}(
  x,
  subid = ".*",
  session = ".*",
  hemi = ".*",
  surf_type = ".*",
  space = ".*",
  full_path = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{bids_project} or \code{mock_bids_project} object.}

\item{subid}{Regex pattern to match subject IDs (without "sub-" prefix).
Default \code{".*"} matches all subjects.}

\item{session}{Regex pattern to match session IDs (without "ses-" prefix).
Default \code{".*"} matches all sessions.}

\item{hemi}{Hemisphere filter: \code{"L"} for left, \code{"R"} for right, or \code{".*"} for both.
Default \code{".*"} matches both hemispheres.}

\item{surf_type}{Surface type filter: \code{"pial"}, \code{"inflated"}, \code{"midthickness"},
\code{"smoothwm"}, \code{"white"}, \code{"sphere"}, \code{"spherereg"}, or \code{".*"} for all types.
Default \code{".*"} matches all surface types.}

\item{space}{Regex pattern to match coordinate space (e.g., \code{"fsnative"}, \code{"fsaverage"}).
Default \code{".*"} matches all spaces.}

\item{full_path}{Logical. If \code{TRUE} (default), return absolute file paths.
If \code{FALSE}, return paths relative to project root.}

\item{...}{Additional arguments passed to \code{search_files}.}
}
\value{
Character vector of file paths matching the criteria, or \code{NULL} if
no matching files are found.
}
\description{
Retrieves paths to surface mesh files (GIFTI format, .gii) from a BIDS project,
optionally filtered by hemisphere and surface type. Surface files are typically
found in fMRIPrep derivatives and represent cortical surface reconstructions
in various coordinate spaces.
}
\examples{
\donttest{
# Get all surface files
tryCatch({
  ds_path <- get_example_bids_dataset("ds000001-fmriprep")
  proj <- bids_project(ds_path, fmriprep = TRUE)

  # All surfaces
  all_surfs <- surface_files(proj)

  # Left hemisphere pial surfaces only
  left_pial <- surface_files(proj, hemi = "L", surf_type = "pial")

  # All surfaces in fsnative space
  fsnative_surfs <- surface_files(proj, space = "fsnative")

  # Clean up
  unlink(ds_path, recursive = TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
