% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_bids.R
\name{read_events.mock_bids_project}
\alias{read_events.mock_bids_project}
\title{Read Event Files from Mock BIDS Project}
\usage{
\method{read_events}{mock_bids_project}(x, subid = ".*", task = ".*", run = ".*", session = ".*", ...)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{subid}{Regex pattern for subject IDs. Default \code{".*"}.}

\item{task}{Regex pattern for task names. Default \code{".*"}.}

\item{run}{Regex pattern for run indices. Default \code{".*"}.}

\item{session}{Regex pattern for session IDs. Default \code{".*"}.}

\item{...}{Additional arguments passed to \code{event_files}.}
}
\value{
A nested tibble with columns \code{.subid}, \code{.task}, \code{.run}, \code{.session} (if applicable),
and \code{data} (containing the event tibbles), or an empty tibble if no matching data.
}
\description{
Retrieves and formats event data stored within the mock project object.
}
\examples{
parts <- c("01")
fs <- tibble::tibble(
  subid = "01", datatype = "func",
  suffix = c("bold.nii.gz", "events.tsv"),
  task = "rest", run = "01", fmriprep = FALSE
)
evt_data <- list()
evt_data[["sub-01/func/sub-01_task-rest_run-01_events.tsv"]] <-
  tibble::tibble(onset = c(1, 5, 10), duration = c(0.5, 0.5, 0.5),
                 trial_type = c("go", "stop", "go"))
mock <- create_mock_bids("EventTest", parts, fs, event_data = evt_data)
events <- read_events(mock)
print(events)
}
