% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{brs_sim}
\alias{brs_sim}
\title{Simulate data from beta interval models}
\usage{
brs_sim(
  formula,
  data,
  beta,
  phi = 1/5,
  zeta = NULL,
  link = "logit",
  link_phi = "logit",
  ncuts = 100L,
  lim = 0.5,
  repar = 2L,
  delta = NULL
)
}
\arguments{
\item{formula}{Model formula with one (mean) or two parts
(mean \code{|} precision). A left-hand-side response is allowed but ignored.}

\item{data}{Data frame with predictor variables.}

\item{beta}{Numeric vector of mean-model coefficients.}

\item{phi}{Scalar dispersion parameter (link scale), used only for one-part
formulas.}

\item{zeta}{Numeric vector of precision-model coefficients (link scale),
required for two-part formulas.}

\item{link}{Mean link function.}

\item{link_phi}{Precision link function.}

\item{ncuts}{Number of scale categories.}

\item{lim}{Half-width used in interval construction.}

\item{repar}{Reparameterization scheme.}

\item{delta}{Forced censoring type (\code{0,1,2,3}) or \code{NULL}.}
}
\value{
A data frame with columns \code{left}, \code{right}, \code{yt},
  \code{y}, \code{delta}, plus simulated predictor columns from the model
  matrices. When \code{delta != NULL}, the output carries
  \code{attr(, "is_prepared") = TRUE}.
}
\description{
Simulates interval-censored responses from fixed- or variable-dispersion
beta regression models.
}
\details{
The model structure is controlled by \code{formula} in the same style as
\code{\link{brs}}:
\itemize{
  \item one-part formula (\code{~ x1 + x2} or \code{y ~ x1 + x2}):
    fixed dispersion using scalar \code{phi}.
  \item two-part formula (\code{~ x1 + x2 | z1} or \code{y ~ x1 + x2 | z1}):
    variable dispersion using coefficient vector \code{zeta}.
}

The \code{delta} argument can force a single censoring type
(\code{0,1,2,3}) for all observations; otherwise, censoring is classified
automatically from simulated scale values via \code{\link{brs_check}}.
}
\examples{
\donttest{
dat <- data.frame(
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
# Fixed dispersion
sim_fixed <- brs_sim(
  formula = ~ x1 + x2, data = dat,
  beta = c(0.2, -0.5, 0.3), phi = 1 / 5
)
# Variable dispersion
sim_var <- brs_sim(
  formula = ~ x1 | x2, data = dat,
  beta = c(0.2, -0.5), zeta = c(0.5, -0.5)
)
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
