% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{brs_fit_fixed}
\alias{brs_fit_fixed}
\title{Fit a fixed-dispersion beta interval regression model}
\usage{
brs_fit_fixed(
  formula,
  data,
  link = "logit",
  link_phi = "logit",
  ncuts = 100L,
  lim = 0.5,
  hessian_method = c("numDeriv", "optim"),
  repar = 2L,
  method = c("BFGS", "L-BFGS-B")
)
}
\arguments{
\item{formula}{Two-sided formula \code{y ~ x1 + x2 + ...}.}

\item{data}{Data frame.}

\item{link}{Mean link function (default \code{"logit"}).}

\item{link_phi}{Dispersion link function (default \code{"logit"}).}

\item{ncuts}{Number of scale categories (default 100).}

\item{lim}{Uncertainty half-width (default 0.5).}

\item{hessian_method}{Character: \code{"numDeriv"} (default) or
\code{"optim"}.  With \code{"numDeriv"} the Hessian is computed
after convergence using \code{\link[numDeriv]{hessian}}, which is
typically more accurate than the built-in optim Hessian.}

\item{repar}{Reparameterization scheme (default 2).}

\item{method}{Optimization method: \code{"BFGS"} (default) or
\code{"L-BFGS-B"}.}
}
\value{
An object of class \code{"brs"}.
}
\description{
Estimates the parameters of a beta regression model with a single
(scalar) dispersion parameter using maximum likelihood.  The
log-likelihood and its gradient are evaluated by the compiled C++
backend supporting the complete likelihood with mixed censoring
types.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs_fit_fixed(y ~ x1 + x2, data = prep)
print(fit)
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
\keyword{internal}
