% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boc.R
\name{boc_catalog}
\alias{boc_catalog}
\title{Fetch Bank of Canada (BoC) available series or group}
\source{
\url{https://www.bankofcanada.ca/valet/docs}
}
\usage{
boc_catalog(type = "groups")
}
\arguments{
\item{type}{(\code{character(1)})\cr
Set of data to return. One of \code{"groups"} or \code{"series"}. Default \code{"groups"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested data.
}
\description{
Access all available series or groups from the Bank of Canada Valet API.
}
\examples{
\dontrun{
catalog <- boc_catalog()
head(catalog)

# filter for effective exchange rate series
dt <- catalog[grepl("CEER", label)]
head(dt)
}
}
