% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.lm_b_bma.R
\name{predict.lm_b_bma}
\alias{predict.lm_b_bma}
\title{Predict method for bma model fits}
\usage{
\method{predict}{lm_b_bma}(object, newdata, CI_level = 0.95, PI_level = 0.95, seed = 1, ...)
}
\arguments{
\item{object}{Object of class bma}

\item{newdata}{An optional data.frame in which to look for variables with which
to predict.}

\item{CI_level}{Posterior probability covered by credible interval}

\item{PI_level}{Posterior probability covered by prediction interval}

\item{seed}{integer. Always set your seed!!!}

\item{...}{optional arguments.}
}
\value{
list.
\itemize{
\item newdata tibble with estimate, prediction intervals, and credible intervals
for the mean.
\item posterior_draws
\itemize{
\item mean_of_ynew draws of \eqn{E(y)}, marginalizing out the model
\item posterior draws of ynew
}
}
}
\description{
Predict method for bma model fits
}
\examples{
\donttest{
# Create data
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5],
             x4 = rnorm(N),
             x5 = rnorm(N),
             x6 = rnorm(N),
             x7 = rnorm(N),
             x8 = rnorm(N),
             x9 = rnorm(N),
             x10 = rnorm(N))
test_data$outcome = 
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )

# Fit linear model using Bayesian model averaging
fit <-
  bma_inference(outcome ~ .,
                test_data,
                user.int = FALSE)
predict(fit)
}

}
