% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{setup_bhm}
\alias{setup_bhm}
\title{Setup BHM Design Object}
\usage{
setup_bhm(k, p0, p_target, mu_mean = NULL, mu_sd = 100)
}
\arguments{
\item{k}{The number of baskets.}

\item{p0}{A common probability under the null hypothesis.}

\item{p_target}{The response rate of interest. See details.}

\item{mu_mean}{Mean of the normal prior distribution for the mean of the
thetas. See details.}

\item{mu_sd}{Standard deviation of the normal prior distribution for the
mean of the thetas.}
}
\value{
An S3 object of class \code{bhm}
}
\description{
Setup BHM Design Object
}
\details{
The class \code{bhm} implements the Bayesian Hierarchical Model
proposed by Berry et al. (2013). Methods for this class are
mostly wrappers for functions from the package \code{bhmbasket}.

In the BHM the thetas of all baskets are modeled, where theta_i =
logit(p_i) - logit(p_target). These thetas are assumed to come from
a normal distribution with mean mu_mean and standard deviation mu_sd.
If \code{mu_mean = NULL} then mu_mean is determined as logit(p0) -
logit(p_target), hence the mean of the normal distribution corresponds
to the null hypothesis.
}
\examples{
design_bhm <- setup_bhm(k = 3, p0 = 0.2, p_target = 0.5)
}
\references{
Berry, S. M., Broglio, K. R., Groshen, S., & Berry, D. A. (2013).
Bayesian hierarchical modeling of patient subpopulations: efficient designs
of phase II oncology clinical trials. Clinical Trials, 10(5), 720-734.
}
