% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_evaluation.R
\name{get_evaluation.exnex}
\alias{get_evaluation.exnex}
\title{Evaluate a Basket Trial with the EXNEX Design}
\usage{
\method{get_evaluation}{exnex}(
  design,
  n,
  r,
  lambda,
  level = 0.95,
  tau_scale,
  w,
  n_mcmc = 10000,
  ...
)
}
\arguments{
\item{design}{An object of class \code{exnex}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{r}{Vector of responses.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{tau_scale}{Standard deviation of the half normal prior exchangeability
distribution for the variance of the thetas.}

\item{w}{Fixed prior weight for the exchangeability part of the model.}

\item{n_mcmc}{Number of MCMC samples.}

\item{...}{Further arguments.}
}
\value{
A list containing the point estimates of the basket-specific response rates.
}
\description{
Evaluate a Basket Trial with the EXNEX Design
}
\examples{
design <- setup_exnex(k = 3, p0 = 0.2)

# Equal sample sizes
get_evaluation(design = design, n = c(20, 20, 20), r = c(10, 15, 5),
  lambda = 0.95, tau_scale = 1, w = 0.5, iter = 100)

# Unequal sample sizes
get_evaluation(design = design, n = c(15, 20, 25), r = c(10, 15, 17),
  lambda = 0.95, tau_scale = 1, w = 0.5, iter = 100)
}
