% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baselinenowcast_df-class.R
\name{new_baselinenowcast_df}
\alias{new_baselinenowcast_df}
\title{Combine data from a nowcast dataframe, strata, and reference dates}
\usage{
new_baselinenowcast_df(baselinenowcast_df, reference_dates, output_type)
}
\arguments{
\item{baselinenowcast_df}{Data.frame containing information for multiple
draws with columns for the reference time (\code{time}), the predicted counts
(\code{pred_count}), and the draw number (\code{draw}).}

\item{reference_dates}{Vector of reference dates corresponding to the
reference times in the \code{baselinenowcast_df}.}

\item{output_type}{Character string indicating whether the output should be
samples (\code{"samples"}) from the estimate with full uncertainty or whether to
return the point estimate (\code{"point"}). Default is \code{"samples"}. If
\code{"point"}estimates are specified, the minimum number of reference times
needed is the number needed for delay estimation, otherwise, if
\code{"samples"} are specified, at least 2 additional reference times are
required for uncertainty estimation.}
}
\value{
An object of class \code{\link{baselinenowcast_df}}
}
\description{
Combines data from a nowcast dataframe, a named list of the
strata associated with the nowcast dataframe, and a vector of reference
dates corresponding to the time column in the \code{baselinenowcast_df}
}
\seealso{
Main nowcasting interface functions
\code{\link{assert_baselinenowcast_df}()},
\code{\link{baselinenowcast}()},
\code{\link{baselinenowcast.data.frame}()},
\code{\link{baselinenowcast.reporting_triangle}()},
\code{\link{baselinenowcast_df-class}}
}
\concept{baselinenowcast_df}
