% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default-credential.R
\name{get_credential_provider}
\alias{get_credential_provider}
\title{Get Credential Provider}
\usage{
get_credential_provider(
  scope = NULL,
  tenant_id = NULL,
  client_id = NULL,
  client_secret = NULL,
  use_cache = "disk",
  offline = TRUE,
  oauth_host = NULL,
  oauth_endpoint = NULL,
  chain = NULL,
  interactive = TRUE,
  verbose = getOption("azr.verbose", FALSE)
)
}
\arguments{
\item{scope}{Optional character string specifying the authentication scope.}

\item{tenant_id}{Optional character string specifying the tenant ID for
authentication.}

\item{client_id}{Optional character string specifying the client ID for
authentication.}

\item{client_secret}{Optional character string specifying the client secret
for authentication.}

\item{use_cache}{Character string indicating the caching strategy. Defaults
to \code{"disk"}. Options include \code{"disk"} for disk-based caching or \code{"memory"}
for in-memory caching.}

\item{offline}{Logical. If \code{TRUE}, adds 'offline_access' to the scope to
request a 'refresh_token'. Defaults to \code{TRUE}.}

\item{oauth_host}{Optional character string specifying the OAuth host URL.}

\item{oauth_endpoint}{Optional character string specifying the OAuth endpoint.}

\item{chain}{A list of credential objects, where each element must inherit
from the \code{Credential} base class. Credentials are attempted in the order
provided until \code{get_token} succeeds. If \code{NULL}, uses
\code{\link[=default_credential_chain]{default_credential_chain()}}.}

\item{interactive}{A logical value indicating whether interactive credentials
are allowed. Defaults to \code{TRUE}.}

\item{verbose}{A logical value indicating whether to print verbose messages
during credential discovery. Defaults to \code{getOption("azr.verbose", FALSE)}.}
}
\value{
A credential object that inherits from the \code{Credential} class and
has successfully authenticated.
}
\description{
Discovers and returns an authenticated credential object from a chain of
credential providers. This function attempts each credential in the chain
until one successfully authenticates, returning the first successful
credential object.
}
\examples{
\dontrun{
# Get a credential provider with default settings
cred <- get_credential_provider(
  scope = "https://graph.microsoft.com/.default",
  tenant_id = "my-tenant-id"
)

# Use the credential to get a token
token <- cred$get_token()
}

}
\seealso{
\code{\link[=get_token_provider]{get_token_provider()}}, \code{\link[=get_request_authorizer]{get_request_authorizer()}},
\code{\link[=default_credential_chain]{default_credential_chain()}}
}
