% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{am_change_deps}
\alias{am_change_deps}
\title{Get the dependencies of a change}
\usage{
am_change_deps(change)
}
\arguments{
\item{change}{An \code{am_change} object (from \code{\link[=am_get_changes]{am_get_changes()}} or
\code{\link[=am_change_from_bytes]{am_change_from_bytes()}})}
}
\value{
A list of raw vectors (change hashes), each 32 bytes. Returns
an empty list for the first change in a document.
}
\description{
Returns the hashes of the changes that this change depends on (i.e.,
its parent changes in the causal graph). The first change in a document
has no dependencies.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "x", 1)
am_commit(doc, "First")
am_put(doc, AM_ROOT, "y", 2)
am_commit(doc, "Second")

history <- am_get_changes(doc)
deps1 <- am_change_deps(history[[1]])
deps1

deps2 <- am_change_deps(history[[2]])
deps2

am_close(doc)

}
