% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_top_anomalies.R
\name{flag_top_anomalies}
\alias{flag_top_anomalies}
\title{Flag Top Anomalies Based on Score Threshold}
\description{
Categorizes records as anomalous or normal based on their anomaly scores,
using either a fixed threshold or a contamination rate.
}
\usage{
flag_top_anomalies(data_with_scores, threshold = NULL, contamination = 0.05)
}
\arguments{
\item{data_with_scores}{A data frame containing an \code{anomaly_score} column,
typically the output of \code{score_anomaly()}.}

\item{threshold}{Numeric value between 0 and 1. Records with anomaly_score
>= threshold are flagged as anomalous. If NULL (default), uses the
contamination rate from the \code{score_anomaly()} attributes.}

\item{contamination}{Numeric value between 0 and 1. If \code{threshold} is NULL,
this proportion of records with the highest scores will be flagged.
Default is 0.05 (5\%).}
}
\value{
The input data frame with an additional \code{is_anomaly} logical column
  indicating whether each record is flagged as anomalous.
}
\examples{
\donttest{
data <- data.frame(
  patient_id = 1:50,
  age = rnorm(50, 50, 15),
  cost = rnorm(50, 10000, 5000)
)
scored_data <- score_anomaly(data)
flagged_data <- flag_top_anomalies(scored_data, contamination = 0.05)
}
}
