% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solar_motion.R
\name{astro_search_sun_longitude}
\alias{astro_search_sun_longitude}
\title{Search for Sun longitude}
\usage{
astro_search_sun_longitude(target_lon, start_time, limit_days)
}
\arguments{
\item{target_lon}{Numeric. The desired ecliptic longitude in degrees,
relative to the true equinox of date. Must be in the range [0, 360).
Conventional values: 0 = March equinox, 90 = June solstice,
180 = September equinox, 270 = December solstice.}

\item{start_time}{POSIXct. The date and time for starting the search.}

\item{limit_days}{Numeric. The number of days to search forward from
\code{start_time}. Recommended range: 1 to 10 days.}
}
\value{
A list with element:
\describe{
\item{time}{POSIXct value indicating when the Sun reaches the target longitude.}
}
}
\description{
Searches for the time when the Sun reaches a specified apparent ecliptic
longitude as seen from the center of the Earth.
}
\details{
This function can be used to determine equinoxes and solstices. However,
for calculating all equinoxes and solstices for a calendar year,
\code{\link[=astro_seasons]{astro_seasons()}} is usually more convenient and efficient.

The search is performed within the time window from \code{start_time} to
\code{start_time + limit_days}. It is recommended to keep the search window
smaller than 10 days when possible.
}
\examples{
# Find the March equinox in 2025
start <- as.POSIXct("2025-03-15", tz = "UTC")
astro_search_sun_longitude(0, start, 10)
}
