% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_EQJ_ECL}
\alias{astro_rotation_EQJ_ECL}
\title{Rotation Matrix from EQJ to ECL}
\usage{
astro_rotation_EQJ_ECL(time_posix)
}
\arguments{
\item{time_posix}{A POSIXct object specifying the date and time at which the Earth's equator
defines the target orientation.}
}
\value{
A rotation matrix that converts EQJ to ECL at the specified time.
}
\description{
Calculates a rotation matrix from J2000 mean equator (EQJ) to J2000 mean
ecliptic (ECL).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: EQJ = equatorial system, using equator at J2000 epoch.

\strong{Target}: ECL = ecliptic system, using equator at J2000 epoch.
}
\examples{
time <- as.POSIXct("2024-01-01", tz = "UTC")
astro_rotation_EQJ_ECL(time)

}
