% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotation.R
\name{astro_rotation_ECT_EQD}
\alias{astro_rotation_ECT_EQD}
\title{Rotation Matrix from ECT to EQD}
\usage{
astro_rotation_ECT_EQD(time)
}
\arguments{
\item{time}{A POSIXct object representing the date and time of the ecliptic/equator conversion.}
}
\value{
A rotation matrix that converts ECT to EQD.
}
\description{
Calculates a rotation matrix from true ecliptic of date (ECT) to equator of date (EQD).
}
\details{
This is one of the family of functions that returns a rotation matrix
for converting from one orientation to another.

\strong{Source}: ECT = true ecliptic of date.

\strong{Target}: EQD = equator of date.
}
\examples{
astro_rotation_ECT_EQD(Sys.time())

}
