% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autonomy.R
\name{autonomy.set}
\alias{autonomy.set}
\title{Set Autonomy Level}
\usage{
autonomy.set(level)
}
\arguments{
\item{level}{\emph{[integer]} The autonomy level to set (1-5).
\itemize{
\item 1 (Minimal): Maximum user control - prompt for all optional decisions
\item 2 (Low): Frequent prompts - ask for most non-critical decisions
\item 3 (Medium): Balanced - prompt for important decisions only
\item 4 (High): Mostly autonomous - minimal prompts for critical decisions only (default)
\item 5 (Full): Fully autonomous - no prompts, use all defaults and auto-detection
}}
}
\value{
\code{NULL} (invisible)
}
\description{
Set the autonomy level for the current session.
This setting controls how much user interaction is required during analysis.
}
\examples{
\dontrun{
# Set to fully autonomous mode
autonomy.set(5)

# Set to balanced mode
autonomy.set(3)
}
}
