% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aridagri-package.R
\name{export_results}
\alias{export_results}
\title{Export Results to Publication Format}
\usage{
export_results(x, file, format = "xlsx", digits = 3, verbose = TRUE)
}
\arguments{
\item{x}{An object from aridagri analysis functions}

\item{file}{Output file path}

\item{format}{Output format: "xlsx"}

\item{digits}{Number of decimal places}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
Invisibly returns the file path
}
\description{
Exports aridagri analysis results to Excel format for publication.
}
\examples{
\donttest{
df <- data.frame(
  yield = c(1200, 1350, 1100, 1450, 1280),
  wue = c(4.2, 4.8, 3.9, 5.1, 4.5)
)
result <- correlation_analysis(df, plot = FALSE)
export_results(result, tempfile(fileext = ".xlsx"))
}

}
\author{
Lalit Kumar Rolaniya, Ram Lal Jat, Monika Punia, Raja Ram Choudhary
}
