% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_split_plot.R
\name{anova_spd_ab_cd}
\alias{anova_spd_ab_cd}
\title{Split Plot Design with (AB) Main and (CD) Sub}
\usage{
anova_spd_ab_cd(
  data,
  response,
  main_factor1,
  main_factor2,
  sub_factor1,
  sub_factor2,
  replication,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{main_factor1}{First factor in main plot (A)}

\item{main_factor2}{Second factor in main plot (B)}

\item{sub_factor1}{First factor in sub-plot (C)}

\item{sub_factor2}{Second factor in sub-plot (D)}

\item{replication}{Name of replication factor}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table and means
}
\description{
Performs ANOVA for Split Plot Design where main plot contains factorial 
combination of AB and sub-plot contains factorial combination of CD.
Complex design for multi-factor experiments.
}
\examples{
# Example: Irrigation  Tillage (main), Variety  Nitrogen (sub)
data <- expand.grid(
  rep = 1:3,
  irrigation = c("I1", "I2"),
  tillage = c("CT", "ZT"),
  variety = c("V1", "V2"),
  nitrogen = c("N1", "N2", "N3")
)
data$yield <- rnorm(nrow(data), 1200, 150)

anova_spd_ab_cd(data, response = "yield",
                main_factor1 = "irrigation", main_factor2 = "tillage",
                sub_factor1 = "variety", sub_factor2 = "nitrogen",
                replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
