% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytics.R
\name{anki_retention_rate}
\alias{anki_retention_rate}
\title{Calculate actual retention rate from review history}
\usage{
anki_retention_rate(path = NULL, profile = NULL, days = 30, by_deck = FALSE)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{days}{Number of days to look back (default 30, NULL for all)}

\item{by_deck}{If TRUE, calculate retention per deck}
}
\value{
A tibble with retention statistics
}
\description{
Calculates the proportion of reviews that were successful (not "Again").
}
\examples{
\dontrun{
retention <- anki_retention_rate()
retention <- anki_retention_rate(days = 90, by_deck = TRUE)
}
}
