% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{rq}
\alias{rq}
\title{Computing the scaled realised quarticity}
\usage{
rq(data, Delta)
}
\arguments{
\item{data}{The data set used to compute the scaled realised quarticity}

\item{Delta}{The width Delta of the observation grid}
}
\value{
The function returns the scaled realised quarticity RQ_n.
}
\description{
This function computes the scaled realised quarticity of a time series
for a given width of the observation grid.
}
\details{
According to
Sauri and Veraart (2022), the scaled realised quarticity for
\eqn{X_0, X_{\Delta_n}, \ldots, X_{(n-1)\Delta_n}} is given by
\deqn{RQ_n:=\frac{1}{\sqrt{2 n\Delta_{n}}}
\sum_{k=0}^{n-2}(X_{(k+1)\Delta_n}-X_{k\Delta_n})^4.}
}
\examples{
##Simulate a trawl process
##Determine the sampling grid
my_n <- 1000
my_delta <- 0.1
my_t <- my_n*my_delta

###Choose the model parameter
#Exponential trawl function:
my_lambda <- 2
#Poisson marginal distribution trawl
my_v <- 1

#Set the seed
set.seed(123)
#Simulate the trawl process
Poi_data<-ambit::sim_weighted_trawl(my_n, my_delta, "Exp", my_lambda, "Poi", my_v)$path

#Compute the scaled realised quarticity
rq(Poi_data, my_delta)
}
