% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{surv.weibull_dist}
\alias{surv.weibull_dist}
\title{Survival function for a Weibull distribution.}
\usage{
\method{surv}{weibull_dist}(x, ...)
}
\arguments{
\item{x}{A \code{weibull_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log.p = FALSE, ...)} returning the
survival probability (or log-survival probability) at \code{t}.
}
\description{
Returns a function that computes \eqn{S(t) = P(X > t)} for the Weibull
distribution.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
S <- surv(x)
S(1)
S(3)
}
