% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal.R
\name{surv.lognormal}
\alias{surv.lognormal}
\title{Survival function for a log-normal distribution.}
\usage{
\method{surv}{lognormal}(x, ...)
}
\arguments{
\item{x}{A \code{lognormal} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log.p = FALSE, ...)} returning the
survival probability (or log-survival probability) at \code{t}.
}
\description{
Returns a function that computes \eqn{S(t) = P(X > t)} for the log-normal
distribution.
}
\examples{
x <- lognormal(0, 1)
S <- surv(x)
S(1)
S(2)
}
