% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.R
\name{lln}
\alias{lln}
\title{Law of Large Numbers Limiting Distribution}
\usage{
lln(base_dist)
}
\arguments{
\item{base_dist}{A \code{dist} object representing the base distribution.}
}
\value{
A \code{normal} or \code{mvn} distribution with zero variance,
representing the degenerate distribution at the mean.
}
\description{
Returns the degenerate limiting distribution of the sample mean
\eqn{\bar{X}_n} under the Law of Large Numbers. The limit is a
point mass at the population mean (represented as a normal or mvn
with zero variance).
}
\examples{
# LLN for Exp(2): Xbar -> 1/2 (degenerate)
x <- exponential(rate = 2)
d <- lln(x)
mean(d)
vcov(d)
}
