% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_dist.R
\name{inv_cdf.poisson_dist}
\alias{inv_cdf.poisson_dist}
\title{Inverse CDF (quantile function) for a Poisson distribution.}
\usage{
\method{inv_cdf}{poisson_dist}(x, ...)
}
\arguments{
\item{x}{A \code{poisson_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(p, lower.tail = TRUE, log.p = FALSE, ...)}
returning the quantile at probability \code{p}.
}
\description{
Returns a function that computes quantiles of the Poisson distribution.
}
\examples{
x <- poisson_dist(5)
q <- inv_cdf(x)
q(0.5)
q(0.95)
}
