% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{inv_cdf.edist}
\alias{inv_cdf.edist}
\title{Inverse CDF (quantile function) for expression distributions.}
\usage{
\method{inv_cdf}{edist}(x, ...)
}
\arguments{
\item{x}{An \code{edist} object.}

\item{...}{Additional arguments forwarded to
\code{inv_cdf.empirical_dist}.}
}
\value{
A function computing the empirical quantile function.
}
\description{
Falls back to \code{\link{realize}} and delegates to
\code{\link{inv_cdf.empirical_dist}}.
}
\examples{
\donttest{
set.seed(1)
z <- normal(0, 1) * exponential(1)
qz <- inv_cdf(z)
qz(0.5)
}
}
