% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{estimateAbundance}
\alias{estimateAbundance}
\title{Estimates the complete clonal relative abundance distribution}
\usage{
estimateAbundance(
  data,
  clone = "clone_id",
  copy = NULL,
  group = NULL,
  min_n = 30,
  max_n = NULL,
  uniform = TRUE,
  ci = 0.95,
  nboot = 200,
  cell_id = "cell_id",
  progress = FALSE
)
}
\arguments{
\item{data}{data.frame with Change-O style columns containing clonal assignments.}

\item{clone}{name of the \code{data} column containing clone identifiers.}

\item{copy}{name of the \code{data} column containing copy numbers for each 
sequence. If \code{copy=NULL} (the default), then clone abundance
is determined by the number of sequences. If a \code{copy} column
is specified, then clone abundances is determined by the sum of 
copy numbers within each clonal group.}

\item{group}{name of the \code{data} column containing group identifiers. 
If \code{NULL} then no grouping is performed and the \code{group} 
column of the output will contain the value \code{NA} for each row.}

\item{min_n}{minimum number of observations to sample.
A group with less observations than the minimum is excluded.}

\item{max_n}{maximum number of observations to sample. If \code{NULL} then no 
maximum is set.}

\item{uniform}{if \code{TRUE} then uniformly resample each group to the same 
number of observations. If \code{FALSE} then allow each group to
be resampled to its original size or, if specified, \code{max_size}.}

\item{ci}{confidence interval to calculate; the value must be between 0 and 1.}

\item{nboot}{number of bootstrap realizations to generate.}

\item{cell_id}{name of the \code{data} column containing cell identifiers. If
\code{cell_id=NULL} then the function will assume bulk data.}

\item{progress}{if \code{TRUE} show a progress bar.}
}
\value{
A \link{AbundanceCurve} object summarizing the abundances.
}
\description{
\code{estimateAbundance} estimates the complete clonal relative abundance distribution 
and confidence intervals on clone sizes using bootstrapping.
}
\examples{
abund <- estimateAbundance(ExampleDb, group="sample_id", nboot=100)

}
\references{
\enumerate{
  \item  Chao A. Nonparametric Estimation of the Number of Classes in a Population. 
           Scand J Stat. 1984 11, 265270.
  \item  Chao A, et al. Rarefaction and extrapolation with Hill numbers: 
           A framework for sampling and estimation in species diversity studies. 
           Ecol Monogr. 2014 84:45-67.
  \item  Chao A, et al. Unveiling the species-rank abundance distribution by 
           generalizing the Good-Turing sample coverage theory. 
           Ecology. 2015 96, 11891201.
}
}
\seealso{
See \link{plotAbundanceCurve} for plotting of the abundance distribution.
See \link{alphaDiversity} for a similar application to clonal diversity.
}
