% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/subset.R
\docType{methods}
\name{flip}
\alias{flip}
\alias{flip,TimeSeries-method}
\title{Transposition}
\usage{
flip(x, ...)

\S4method{flip}{TimeSeries}(x)
}
\arguments{
\item{x}{A \eqn{n \times m \times p} \code{\linkS4class{TimeSeries}} object.}

\item{...}{Currently not used.}
}
\value{
A permuted (\eqn{n \times p \times m}) \code{\linkS4class{TimeSeries}} object.
}
\description{
Transposes a time series object by permuting its dimensions and resizing it.
}
\examples{
## Create 6 x 3 time-series of 50 observations
## Sampled every two years starting from 2000 BP
X <- series(
  object = array(rnorm(900), dim = c(50, 6, 3)),
  time = seq(2000, by = 2, length.out = 50),
  calendar = BP()
)
plot(X, calendar = BP())

## Permute dimensions 2 and 3
## 3 x 6 time-series of 50 observations
Y <- flip(X)
plot(Y, calendar = BP())
}
\seealso{
Other mutators: 
\code{\link{as.data.frame}()},
\code{\link{labels}()},
\code{\link{length}()},
\code{\link{names}()},
\code{\link{subset}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
