testthat::test_that("pa_check 0 length", {
  testthat::expect_equal(pa_check(character(0)), logical(0))
})

testthat::test_that("pa_check NA_character_", {
  testthat::expect_false(pa_check(NA_character_))
})

test_that("pa_check too long or too short", {
  expect_false(pa_check("AAA0100000070"))
  expect_false(pa_check("AAA01000000"))
})

test_that("pa_check non-numeric characters", {
  expect_false(pa_check("AAABADAFM990"))
  expect_false(pa_check("AAABADAFM991"))
  expect_false(pa_check("AAABADAFM992"))
  expect_false(pa_check("AAABADAFM993"))
  expect_false(pa_check("AAABADAFM994"))
  expect_false(pa_check("AAABADAFM995"))
  expect_false(pa_check("AAABADAFM996"))
  expect_false(pa_check("AAABADAFM997"))
  expect_false(pa_check("AAABADAFM998"))
  expect_false(pa_check("AAABADAFM999"))
})

test_that("pa_check bad checksum digit", {
  expect_false(pa_check("XYA010000007"))

  expect_false(pa_check("AXO123456783"))
  expect_false(pa_check("12X123456783"))
})

test_that("pa_check correct FIGI", {
  expect_true(pa_check("XYT010000007"))
  expect_true(pa_check("XYA011111111"))
  expect_true(pa_check("5XY123456783"))
  expect_true(pa_check("AAP123456783"))
})

test_that("pa_check test character vector", {
  res <- c(TRUE, FALSE, FALSE, FALSE)
  expect_equal(pa_check(c("XYT010000007", "AXO123456789",
                          "x", NA_character_)), res)
})


test_that("pa_compute_checksum", {
  expect_equal(pa_compute_checksum("010000007XY"), "T")
  expect_equal(pa_compute_checksum("1234567835X"), "Y")
  expect_equal(pa_compute_checksum("123456783AA"), "P")
})
