% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_transposed.R
\name{derive_vars_transposed}
\alias{derive_vars_transposed}
\title{Derive Variables by Transposing and Merging a Second Dataset}
\usage{
derive_vars_transposed(
  dataset,
  dataset_merge,
  by_vars,
  id_vars = NULL,
  key_var,
  value_var,
  filter = NULL,
  relationship = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{dataset_merge}{Dataset to transpose and merge

The variables specified by the \code{by_vars}, \code{id_vars}, \code{key_var} and
\code{value_var} arguments are expected. The variables \code{by_vars}, \code{id_vars},
\code{key_var} have to be a unique key.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

Keys used to merge \code{dataset_merge} with \code{dataset}.

\describe{
\item{Default value}{none}
}}

\item{id_vars}{ID variables

Variables (excluding \code{by_vars} and \code{key_var}) that uniquely identify each
observation in \code{dataset_merge}.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{key_var}{The variable of \code{dataset_merge} containing the names of the
transposed variables

\describe{
\item{Default value}{none}
}}

\item{value_var}{The variable of \code{dataset_merge} containing the values of the
transposed variables

\describe{
\item{Default value}{none}
}}

\item{filter}{Expression used to restrict the records of \code{dataset_merge} prior to transposing

\describe{
\item{Default value}{\code{NULL}}
}}

\item{relationship}{Expected merge-relationship between the \code{by_vars}
variable(s) in \code{dataset} and \code{dataset_merge} (after transposition)

This argument is passed to the \code{dplyr::left_join()} function. See
\url{https://dplyr.tidyverse.org/reference/mutate-joins.html#arguments} for
more details.

\describe{
\item{Permitted values}{\code{"one-to-one"}, \code{"one-to-many"}, \code{"many-to-one"},
\code{"many-to-many"}, \code{NULL}}
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with transposed variables from \code{dataset_merge} added
}
\description{
Adds variables from a vertical dataset after transposing it into a wide one.
}
\details{
\enumerate{
\item The records from the dataset to transpose and merge (\code{dataset_merge}) are restricted
to those matching the \code{filter} condition, if provided.
\item The records from \code{dataset_merge} are checked to ensure they are uniquely identified
using \code{by_vars}, \code{id_vars} and \code{key_var}.
\item \code{dataset_merge} is transposed (from "tall" to "wide"), with new variables added whose
names come from \code{key_var} and values come from \code{value_var}.
\item The transposed dataset is merged with the input \code{dataset} using \code{by_vars} as
keys. If a \code{relationship} has been provided, this merge must satisfy the relationship,
otherwise an error is thrown.
}

Note that unlike other \verb{derive_vars_*()} functions, the final step may cause new
records to be added to the input dataset. The \code{relationship} argument can be specified
to ensure this does not happen inadvertently.
}
\examples{
library(tibble)
library(dplyr, warn.conflicts = FALSE)

# Adding ATC classes to CM using FACM
cm <- tribble(
  ~USUBJID,       ~CMGRPID, ~CMREFID,  ~CMDECOD,
  "BP40257-1001", "14",     "1192056", "PARACETAMOL",
  "BP40257-1001", "18",     "2007001", "SOLUMEDROL",
  "BP40257-1002", "19",     "2791596", "SPIRONOLACTONE"
)
facm <- tribble(
  ~USUBJID,       ~FAGRPID, ~FAREFID,  ~FATESTCD,  ~FASTRESC,
  "BP40257-1001", "1",      "1192056", "CMATC1CD", "N",
  "BP40257-1001", "1",      "1192056", "CMATC2CD", "N02",
  "BP40257-1001", "1",      "1192056", "CMATC3CD", "N02B",
  "BP40257-1001", "1",      "1192056", "CMATC4CD", "N02BE",
  "BP40257-1001", "1",      "2007001", "CMATC1CD", "D",
  "BP40257-1001", "1",      "2007001", "CMATC2CD", "D10",
  "BP40257-1001", "1",      "2007001", "CMATC3CD", "D10A",
  "BP40257-1001", "1",      "2007001", "CMATC4CD", "D10AA",
  "BP40257-1001", "2",      "2007001", "CMATC1CD", "D",
  "BP40257-1001", "2",      "2007001", "CMATC2CD", "D07",
  "BP40257-1001", "2",      "2007001", "CMATC3CD", "D07A",
  "BP40257-1001", "2",      "2007001", "CMATC4CD", "D07AA",
  "BP40257-1001", "3",      "2007001", "CMATC1CD", "H",
  "BP40257-1001", "3",      "2007001", "CMATC2CD", "H02",
  "BP40257-1001", "3",      "2007001", "CMATC3CD", "H02A",
  "BP40257-1001", "3",      "2007001", "CMATC4CD", "H02AB",
  "BP40257-1002", "1",      "2791596", "CMATC1CD", "C",
  "BP40257-1002", "1",      "2791596", "CMATC2CD", "C03",
  "BP40257-1002", "1",      "2791596", "CMATC3CD", "C03D",
  "BP40257-1002", "1",      "2791596", "CMATC4CD", "C03DA"
)

cm \%>\%
  derive_vars_transposed(
    dataset_merge = facm,
    by_vars = exprs(USUBJID, CMREFID = FAREFID),
    id_vars = exprs(FAGRPID),
    key_var = FATESTCD,
    value_var = FASTRESC
  ) \%>\%
  select(USUBJID, CMDECOD, starts_with("CMATC"))

# Note: the `id_vars` argument here is needed to uniquely identify
# rows of dataset_merge and avoid duplicates-related errors.
# Compare the above call to when `id_vars = NULL`:

try(
  cm \%>\%
    derive_vars_transposed(
      dataset_merge = facm,
      by_vars = exprs(USUBJID, CMREFID = FAREFID),
      id_vars = NULL,
      key_var = FATESTCD,
      value_var = FASTRESC
    )
)
}
\seealso{
\code{\link[=derive_vars_atc]{derive_vars_atc()}}

General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_merged_ef_msrc}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_vars_cat}()},
\code{\link{derive_vars_computed}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_joined_summary}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged_summary}()}
}
\concept{der_gen}
\keyword{der_gen}
