% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicadores.R
\name{indicadores}
\alias{indicadores}
\title{Calcula indicadores financeiros de liquidez e endividamento}
\usage{
indicadores(df)
}
\arguments{
\item{df}{Um \code{data.frame} com colunas representando anos (valores numericos) e uma coluna chamada
\code{Categoria}, contendo os rotulos padronizados das contas contabeis agregadas.}
}
\value{
Um \code{data.frame} onde cada linha representa um indicador financeiro e cada coluna subsequente
representa o valor do indicador para um determinado ano.
}
\description{
Esta funcao recebe um data frame resultante da agregacao de contas contabeis por categoria
(geralmente produzido pela funcao \code{processar_balanco}) e calcula indicadores classicos de
liquidez e endividamento com base nas categorias padronizadas: \code{ACO}, \code{ACF}, \code{PCO},
\code{PCF}, \code{ANC}, \code{PNC} e \code{PL}.
}
\details{
As categorias devem seguir os seguintes significados:
\itemize{
  \item \code{ACO}: Ativo Circulante Operacional
  \item \code{ACF}: Ativo Circulante Financeiro
  \item \code{PCO}: Passivo Circulante Operacional
  \item \code{PCF}: Passivo Circulante Financeiro
  \item \code{ANC}: Ativo Nao Circulante
  \item \code{PNC}: Passivo Nao Circulante
  \item \code{PL}: Patrimonio Liquido
}

Indicadores calculados:
\itemize{
  \item \strong{Liquidez Corrente:} (ACO + ACF) / (PCO + PCF)
  \item \strong{Liquidez Seca:} ACO / (PCO + PCF)
  \item \strong{Liquidez Imediata:} ACF / (PCO + PCF)
  \item \strong{Endividamento Geral:} (PCO + PCF + PNC) / (ACO + ACF + ANC)
  \item \strong{Composicao do Endividamento:} (PCO + PCF) / (PCO + PCF + PNC)
  \item \strong{Imobilizacao do PL:} ANC / PL
}
}
\examples{
# Criando um data frame de balanço com todas as categorias essenciais
df <- data.frame(
  Categoria = c("ACO", "ACF", "PCO", "PCF", "ANC", "PNC", "PL"),
  X2022 = c(1000, 500, 600, 400, 2000, 1500, 2000),
  X2023 = c(1200, 600, 700, 500, 2200, 1600, 2300)
)

# Calculando os indicadores
indicadores(df)

}
