% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoms.R
\name{scale_y_pareto}
\alias{scale_y_pareto}
\title{Pareto y-scale with cumulative percentage axis}
\usage{
scale_y_pareto(
  sum_abs = NULL,
  name = ggplot2::waiver(),
  percent_name = "Cumulative (\%)",
  ...
)
}
\arguments{
\item{sum_abs}{Total absolute value used for percentage conversion, typically
\code{sum(abs(y))} from the source data. When \code{NULL} (default), the secondary
axis is scaled to the current primary-axis maximum.}

\item{name}{Primary y-axis label.}

\item{percent_name}{Secondary y-axis label.}

\item{...}{Additional arguments passed to \code{\link[ggplot2:scale_continuous]{ggplot2::scale_y_continuous()}}.}
}
\description{
\code{scale_y_pareto()} configures a primary y-axis for absolute values and a
secondary right-side axis that maps cumulative totals to percentages.
}
\details{
Use this with \code{geom_pareto_line(cumulative = "raw")} so the cumulative line
ends at 100\% on the secondary axis.
}
