% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R, R/printFunctions.R
\name{predict.buhlmannStraub}
\alias{predict.buhlmannStraub}
\alias{buhlmannStraub-class}
\alias{print.buhlmannStraub}
\alias{summary.buhlmannStraub}
\alias{fitted.buhlmannStraub}
\title{Class "buhlmannStraub" of fitted Buhlmann-Straub credibility models}
\usage{
\method{predict}{buhlmannStraub}(object, newdata = NULL, ...)

\method{print}{buhlmannStraub}(x, ...)

\method{summary}{buhlmannStraub}(object, ...)

\method{fitted}{buhlmannStraub}(object, ...)
}
\arguments{
\item{object}{an object of class \code{\link{buhlmannStraub}}}

\item{newdata}{optionally, a data frame in which to look for variables with which to predict.}

\item{...}{currently ignored.}

\item{x}{an object of class \code{\link{buhlmannStraub}}}
}
\value{
The function \code{\link{buhlmannStraub}} returns an object of class \code{buhlmannStraub}, which has the following slots:

\item{call}{the matched call}

\item{type}{Whether additive or multiplicative credibility model is used.}

\item{Variances}{The estimated variance components. \code{Sigma} is the estimated within-group variance,
 and \code{Tau} is the estimate of the between-group variance.}

\item{Means}{The estimated averages at the portfolio level (collective premium \eqn{\hat{\mu}}) and
at the cluster level (weighted average \eqn{\bar{Y}_j}).}

\item{Weights}{The total weights \eqn{w_j} for each cluster.}

\item{Credibility}{The credibility factors \eqn{z_j} for each cluster.}

\item{Premiums}{The collective premium \eqn{\hat{\mu}} and individual premiums \eqn{\hat{V}_j} for each cluster.}

\item{Relativity}{The estimated random effects \eqn{\hat{U}_j} of each cluster.}

\item{RawResults}{Object of type \code{data.table} with all intermediate results.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}
}
\description{
Class "buhlmannStraub" of fitted Buhlmann-Straub credibility models
}
\section{{S3 methods}}{

\describe{
 \item{\code{print}:}{Prints the \code{call}, the estimated variance parameters and the unique number of clusters.
  The \code{...} argument is currently ignored. Returns an invisible copy of the original object.}
 \item{\code{summary}:}{In addition to the output of the \code{print.buhlmannStraub} function, the \code{summary} function
  prints the cluster-level estimates as well. Returns an invisible copy of the original object.}
  \item{\code{fitted}:}{Returns the fitted values.}
}
}

\seealso{
\code{\link{buhlmannStraub}}
}
