% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_score.R
\name{vertices_est}
\alias{vertices_est}
\title{The vertex hunting in the Topic SCORE algorithm}
\usage{
vertices_est(R, K0, m, num_restart)
}
\arguments{
\item{R}{The p-by-(K-1) data matrix, with each row being a data point.}

\item{K0}{The number of greedy search steps.}

\item{m}{The number of centers in the kmeans step.}

\item{num_restart}{The number of random start in the kmeans step.}
}
\value{
A list containing \describe{
  \item{V}{The K-by-(K-1) vertices matrix, with each row being a vertex in the found simplex.}
  \item{theta}{The K0-by-(K-1) matrix of potential K0 vertices found in the greedy step.}
}
}
\description{
This function conducts the vertex hunting in the Topic SCORE algorithm.
More generally this function finds a simplex with K vertices that best approximates
the given p data points in a (K-1) dimensional space.
}
\examples{
# Generate 3 vertices
V <- rbind(c(-1/2,-1/2), c(1,0), c(0,1))

# Randomly generate the convex combination weights of 1000 points
Pi <- matrix(runif(3*1000),3,1000)
Pi <- apply(Pi, 2, function(x){x/sum(x)})

R <- t(Pi)\%*\%V
v_est_obj <- vertices_est(R, 1.5*3, 10*3, 1)

# Visualize the result
plot(R[,1], R[,2])
points(v_est_obj$V[,1], v_est_obj$V[,2], col=2, lwd=5)
}
\references{
Ke, Z. T., & Wang, M. (2017). A new SVD approach to optimal topic estimation. arXiv preprint arXiv:1704.07016.
}
\author{
Minzhe Wang
}
