% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{moments_graph}
\alias{moments_graph}
\title{moments_graph}
\usage{
moments_graph(
  moments_df,
  statistics_per_observation,
  statistics_factor_name,
  statistics_factor_name_breaks = NULL,
  statistics_factor_name_col = NULL,
  output_path = NULL,
  dpi = 600
)
}
\arguments{
\item{moments_df}{Moments data frame (mean, variance, skewness, kurtosis)}

\item{statistics_per_observation}{SES of the Moments data frame and
significance compared to null model}

\item{statistics_factor_name}{column of data use for colors discrimination}

\item{statistics_factor_name_breaks}{vector of factor levels of the
statistics_factor_name, same dimension than statistics_factor_name_col}

\item{statistics_factor_name_col}{vector of colors, same dimension than
statistics_factor_name_breaks}

\item{output_path}{The path to save the graph}

\item{dpi}{The dpi number to use when we generate png/jpg graph}
}
\value{
A graph instance
}
\description{
Graph of the distributions' moments (mean, variance, skewness and
kurtosis) compared to null model
}
\examples{

\donttest{

  results <- TAD::launch_analysis_tad(
    weights = TAD::AB[, 5:102],
    weights_factor = TAD::AB[, c("Year", "Plot", "Treatment", "Bloc")],
    trait_data = log(TAD::trait[["SLA"]]),
    aggregation_factor_name = c("Year", "Bloc"),
    statistics_factor_name = (statistics_factor_name <- c("Treatment")),
    randomization_number = 100
  )

  # if you want to display the graph
  graph <- TAD::moments_graph(
    moments_df = results$weighted_moments,
    statistics_per_observation = results$statistics_per_observation,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159")
  )

  plot(graph)

  # if you want to save the graph as a file
  # either jpg, jpeg, png or svg are
  output_path <- file.path(tempdir(), "outputs")
  dir.create(output_path)
  TAD::moments_graph(
    moments_df = results$weighted_moments,
    statistics_per_observation = results$statistics_per_observation,
    statistics_factor_name = statistics_factor_name,
    statistics_factor_name_breaks = c("Mown_Unfertilized", "Mown_NPK"),
    statistics_factor_name_col = c("#1A85FF", "#D41159"),
    output_path = file.path(output_path, "moment_graph.png")
  )

  unlink(output_path, recursive = TRUE, force = TRUE)

}

}
