% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_img2measure.R
\name{img2measure}
\alias{img2measure}
\title{Extract a discrete measure from a gray-scale image matrix}
\usage{
img2measure(X, threshold = TRUE)
}
\arguments{
\item{X}{An \eqn{(N,2)} nonnegative matrix representing a gray-scale image, where each entry 
corresponds to a pixel intensity.}

\item{threshold}{A logical flag indicating whether to threshold very small weights smaller than machine epsilon.}
}
\value{
A named list containing\describe{
\item{support}{an \eqn{(M\times 2)} matrix of coordinates for the nonzero pixels, where each row is a point \eqn{(x,y)}.}
\item{weight}{a length-\eqn{M} vector of weights corresponding to the nonzero pixels, summing to \eqn{1}.}
}
}
\description{
This function takes a gray-scale image represented as a matrix \eqn{X} and
converts it into a discrete measure suitable for optimal transport computations
in a Lagrangian framework. Pixel intensities are normalized to sum to one, and
the nonzero pixels are represented as weighted points (support and weights).
}
\examples{
\donttest{
#-------------------------------------------------------------------
#                           Description
#
# Take a digit image and compare visualization.
#-------------------------------------------------------------------
# load the data and select the first image
data(digit3)
img_matrix = digit3[[1]]

# extract a discrete measure
img_measure = img2measure(img_matrix, threshold=TRUE)
w  <- img_measure$weight
w_norm <- w / max(w)          # now runs from 0 to 1
col_scale <- gray(1 - w_norm) # 1 = white, 0 = black

# visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
image(img_matrix, xaxt="n", yaxt="n", main="Image Matrix")
plot(img_measure$support, 
     col = col_scale, xlab="", ylab="",
     pch = 19, cex = 0.5, xaxt = "n", yaxt = "n",
     main = "Extracted Discrete Measure")
par(opar)
}

}
\concept{other}
