% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{TRIbi}
\alias{TRIbi}
\alias{TRIbi.numeric}
\alias{TRIbi.SpatRaster}
\title{TRIbi: TRI with bilinear interpolation along diagonals}
\usage{
TRIbi(x, ...)

\method{TRIbi}{numeric}(x, ...)

\method{TRIbi}{SpatRaster}(x, ..., .method = c("rcpp", "r"))
}
\arguments{
\item{x}{A DEM/image as a SpatRaster or a vector of numeric values from a focal window in a DEM from which to compute the index}

\item{...}{reserved for future use}

\item{.method}{Either \code{r} or \code{rcpp} (fast batch processing using C++)}
}
\value{
TRI (in the same units of input)
}
\description{
TRI is based on DDs of first order (at least in its original definition),
however, it does not take into account the different distances between the pixels
on the diagonals with respect to the cardinal ones.
This version corrects with bilinear interpolation to get the right distance. As TRI, it is a proxy of slope!
}
\examples{
library(terra)
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
roughTRIbi=TRIbi(dem)
plot(roughTRIbi)#proxy of slope!
}
\references{
Trevisani S., Teza G., Guth P.L., 2023. Hacking the topographic ruggedness index. Geomorphology,
\doi{doi:10.1016/j.geomorph.2023.108838}.
}
