% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{MadscanL}
\alias{MadscanL}
\title{Calculate MAD basic indices (version for large files)}
\usage{
MadscanL(inRaster, kernels, w)
}
\arguments{
\item{inRaster}{The DEM/residual-dem/image from which to compute the indices}

\item{kernels}{The kernels to be used for computing the directional differences (e.g. order 1,2 and 4 for various lags)}

\item{w}{The moving window adopted for computing the geostatistical index (i.e., MAD)}
}
\value{
A list of 3 rasters: 1)isotropic roughness; 2) direction of anisotropy;3)index of anisotropy.
}
\description{
Calculate MAD basic indices considering a specif lag and difference of order K.
It computes 3 indices of roughness/image texture: isotropic/omnidirectional; direction of maximum continuity; anisotropy index.
The anisotropy index is based on vector dispersion approach: 0 minimum anisotropy; 1 maximum anisotropy.
The direction of anisotropy is in degrees according to geographical convention.
This version clean and remove unused files so as to reduce the consumption of disk space.
When non necessary prefer Madscan(). Work is in progress to create a still more memory (ram and disk)
efficient function.
}
\examples{
# MAD for lag 2 with differences of order 2 using a circular search window of radius 3.
# Using differences of order 1, you should
# apply these on a detrended surface/image.
library(terra)
dem=rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
w=KernelCircular(3)
rough2c=MadscanL(dem,k2ck2, w)
#Plot isotropic roughness
plot(rough2c$IsoRough)
#Plot anisotropy index/strenght
plot(rough2c$AnisoR)

}
\references{
\enumerate{
\item Trevisani, S. & Rocca, M. 2015. MAD: Robust image texture analysis for applications in high resolution geomorphometry.
Computers and Geosciences, vol. 81, pp. 78-92, \doi{doi:10.1016/j.cageo.2015.04.003}.
\item Trevisani, S. Teza, G., Guth, P., 2023. A simplified geostatistical approach for characterizing key aspects of short-range roughness.
CATENA,Volume 223, ISSN 0341-8162,\doi{doi:10.1016/j.catena.2023.106927}.
\item Trevisani, S., Guth, P.L., 2025. Surface Roughness in Geomorphometry: From Basic Metrics Toward a Coherent Framework.
Remote Sensing 17, \doi{doi:10.3390/rs17233864}.
}
}
