% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sun_irrad_et.r
\name{irrad_extraterrestrial}
\alias{irrad_extraterrestrial}
\title{Extraterrestrial solar irradiance}
\usage{
irrad_extraterrestrial(
  time = lubridate::now(tzone = "UTC"),
  tz = lubridate::tz(time),
  geocode = data.frame(lon = 0, lat = 51.5, address = "Greenwich"),
  solar.constant = "NASA"
)
}
\arguments{
\item{time}{A "vector" of POSIXct Time, with any valid time zone (TZ) is
allowed, default is current time.}

\item{tz}{character string indicating time zone to be used in output.}

\item{geocode}{data frame with variables lon and lat as numeric values
(degrees), nrow > 1, allowed.}

\item{solar.constant}{numeric or character If character, "WMO" or "NASA", if
numeric, an irradiance value in the same units as the value to be returned.}
}
\value{
Numeric vector of extraterrestrial irradiance (in W / m2 if solar
  constant is a character value).
}
\description{
Estimate of down-welling solar (short wave) irradiance at the top of the
atmosphere above a location on Earth, computed based on angles, Sun-Earth
distance and the solar constant. Astronomical computations are done with
function \code{sun_angles()}.
}
\examples{
library(lubridate)

irrad_extraterrestrial(ymd_hm("2021-06-21 12:00", tz = "UTC"))

irrad_extraterrestrial(ymd_hm("2021-12-21 20:00", tz = "UTC"))

irrad_extraterrestrial(ymd_hm("2021-06-21 00:00", tz = "UTC") + hours(1:23))

}
\seealso{
Function \code{\link[SunCalcMeeus]{sun_angles}}.
}
