% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOCbyPT_Grade.R
\name{SOCbyPT_Grade}
\alias{SOCbyPT_Grade}
\title{SOC → PT summary by treatment with Grade split (wide)}
\usage{
SOCbyPT_Grade(
  indata,
  dmdata,
  pop_data = NULL,
  group_vars,
  trtan_coln,
  grade_num = "AETOXGRN",
  grade_char = NULL,
  by_var = NULL,
  by_sort_var = NULL,
  by_sort_numeric = TRUE,
  bigN_by = NULL,
  print_bigN = FALSE,
  id_var = "USUBJID",
  rtf_safe = TRUE,
  indent_str = "(*ESC*)R/RTF\\"\\\\li360 \\"",
  use_sas_round = FALSE,
  header_blank = TRUE,
  soc_totals = FALSE,
  total_label = "TOTAL SUBJECTS WITH AN EVENT",
  nr_char_values = c("NOT REPORTED", "NOT_REPORTED", "NOTREPORTED", "NOT REPRTED", "NR",
    "N", "NA"),
  sort_grade = 5,
  debug = FALSE,
  uncoded_position = c("count", "last")
)
}
\arguments{
\item{indata}{\code{data.frame}. AE-like data containing \code{USUBJID}, treatment,
SOC, PT, and Grade variables.}

\item{dmdata}{\code{data.frame}. ADSL-like data containing denominators per arm
(must include \code{USUBJID} and the same treatment column as in \code{indata}).}

\item{pop_data}{\code{data.frame} or \code{NULL}. Optional master population for arm Ns
(defaults to \code{dmdata}).}

\item{group_vars}{Character vector of length 3: \code{c(main_trt, soc, pt)}.
Example: \code{c("TRTAN","AEBODSYS","AEDECOD")}.}

\item{trtan_coln}{Character or numeric. The \strong{reference treatment code} used
for ordering SOC/PT blocks (e.g., \code{"12"}).}

\item{grade_num}{Character. Name of numeric grade column (default \code{"AETOXGRN"}).
Values 1–5 are treated as valid grades; others are ignored in numeric logic.}

\item{grade_char}{Character or \code{NULL}. Optional character grade column name
(e.g., \code{"AETOCGR"}/\code{"AETOXGR"}). If \code{NULL}, the function auto-detects
\code{"AETOCGR"} then \code{"AETOXGR"} if present.}

\item{by_var}{Character or \code{NULL}. Optional BY variable (from AE dataset) to
generate stratified outputs and sort independently per stratum.}

\item{by_sort_var}{Character or \code{NULL}. Optional helper column to order BY
strata; defaults to \code{by_var} when \code{NULL}.}

\item{by_sort_numeric}{Logical. If \code{TRUE} (default), order BY strata by
\code{as.numeric(by_sort_var)}, else use character order.}

\item{bigN_by}{Flag controlling denominator behavior when BY is used:
\itemize{
\item \code{NULL} / \code{"NO"} (default): denominators are by treatment only (not stratified by BY)
\item \code{"YES"}: denominators are by BY × treatment (requires \code{by_var} in \code{dmdata} or \code{pop_data})
}}

\item{print_bigN}{If \code{TRUE}, prints denominators (Big-N) used for percent calculations to console/log.}

\item{id_var}{Character. Subject ID column (default \code{"USUBJID"}).}

\item{rtf_safe}{Logical. If \code{TRUE} (default), prefix PT rows with \code{indent_str}.}

\item{indent_str}{Character. The RTF literal for indentation of PT lines
(default \verb{(*ESC*)R/RTF\\"\\\\li360 \\"}).}

\item{use_sas_round}{Logical. If \code{TRUE}, use SAS-style rounding for
percentages; else base R \code{round()}.}

\item{header_blank}{Logical. If \code{TRUE} (default) and \code{soc_totals = FALSE},
grade columns on SOC header rows are blanked.}

\item{soc_totals}{Logical. If \code{TRUE}, include SOC subtotal rows using the same
grade logic as PT rows.}

\item{total_label}{Character. Label for the top row (default
\code{"TOTAL SUBJECTS WITH AN EVENT"}).}

\item{nr_char_values}{Character vector. Values in \code{grade_char} that are
considered "Not Reported". Default includes multiple NR encodings.}

\item{sort_grade}{Integer or character. \strong{Grade used for ordering} within the
reference arm (default \code{5}). Use \code{"NOT REPORTED"} (or any synonym in
\code{nr_char_values}) to sort by NR instead.}

\item{debug}{Logical. If \code{TRUE}, prints debug summaries.}

\item{uncoded_position}{Character. One of \code{c("count","last")}. Controls
the placement of the UNCODED block: \code{"count"} = position by counts (default);
\code{"last"} = force \code{SOC == "UNCODED"} to the end (per BY stratum) and
\code{PT == "UNCODED"} last within that SOC.}
}
\value{
A tibble with columns:
\itemize{
\item \code{stat}
\item For each treatment and each grade bucket:
\code{TRT<trt>_GRADE1}, …, \code{TRT<trt>_GRADE5}, \code{TRT<trt>_NOT_REPORTED}
\item \code{sort_ord}, \code{sec_ord}
}
}
\description{
Summarises AEs by \strong{System Organ Class (SOC)} → \strong{Preferred Term (PT)} per
treatment arm and splits each arm into \strong{Grade} buckets (1–5 + NOT REPORTED).
The table includes a first \strong{TOTAL SUBJECTS WITH AN EVENT} row, optional SOC
subtotal rows, and RTF-safe indenting for PT lines. The SOC/PT block order can
be driven by a reference arm (e.g., \code{TRTAN = 12}) and \strong{a specific grade} via
\code{sort_grade} (default 5).
}
\section{Key features}{

\itemize{
\item \strong{Grades from numeric and/or character sources}: Uses \code{grade_num} (1–5). If
a character grade column exists (e.g., \code{"AETOCGR"}/\code{"AETOXGR"}), it is
cleaned and mapped, with values in \code{nr_char_values} treated as \emph{Not Reported}.
\item \strong{NR logic}: (a) For PT rows, a subject contributes the \strong{max numeric grade}
among 1–5 (NR ignored). (b) For the top \strong{TOTAL} row, if any PT for the
subject is \strong{NR-only} (no numeric grade), the subject contributes to
\strong{NOT REPORTED}; otherwise to their \strong{max numeric grade}.
\item \strong{Ordering}: Within SOC/PT, order is determined using counts from the
reference arm \code{trtan_coln} filtered to \code{sort_grade} (fallback = all grades).
\item \strong{BY support}: Optional \code{by_var} (from AE) adds strata with optional
\code{by_sort_var} to control strata ordering (numeric or character).
\item \strong{SOC totals}: \code{soc_totals = TRUE} adds a SOC subtotal row (max-grade logic).
\item \strong{Denominators}: Ns are computed from \code{dmdata} (or \code{pop_data}, if provided).
\item \strong{Big N behavior with BY}: controlled by \code{bigN_by} (TRT-only vs BY×TRT).
\item \strong{RTF-safe indent}: PT \code{stat} values can be indented using \code{indent_str}.
\item \strong{SAS-style rounding}: Percentages can follow SAS “round half away from
zero” via \code{use_sas_round = TRUE}.
\item \strong{UNCODED placement}: \code{uncoded_position = c("count","last")}. With \code{"last"},
the block where \code{SOC == "UNCODED"} is forced to the very end (per BY stratum),
and within that SOC the \code{PT == "UNCODED"} line is forced last. Detection is
case-insensitive and robust to extra spaces/non-breaking spaces.
}
}

\examples{

library(dplyr)

adae <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~AEBODSYS,           ~AEDECOD,          ~AETOXGRN,
  "01",       11,   "GASTROINTESTINAL",  "NAUSEA",          2,
  "01",       11,   "GASTROINTESTINAL",  "VOMITING",        3,
  "02",       11,   "GASTROINTESTINAL",  "NAUSEA",          5,
  "03",       12,   "NERVOUS SYSTEM",    "HEADACHE",        1,
  "03",       12,   "NERVOUS SYSTEM",    "DIZZINESS",       2,
  "04",       12,   "GASTROINTESTINAL",  "NAUSEA",          4
)

adsl <- tibble::tribble(
  ~USUBJID, ~TRTAN,
  "01",       11,
  "02",       11,
  "03",       12,
  "04",       12
)

out1 <- SOCbyPT_Grade(
  indata     = adae,
  dmdata     = adsl,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12"   # reference arm for ordering
)

out1



out2 <- SOCbyPT_Grade(
  indata       = adae,
  dmdata       = adsl,
  group_vars   = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln   = "12",
  soc_totals   = TRUE,
  header_blank = TRUE
)

out2


adae2 <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~AEBODSYS,          ~AEDECOD,     ~AETOXGRN, ~AETOXGR,
  "01",       11,   "GASTROINTESTINAL", "NAUSEA",     2,         "",
  "02",       11,   "GASTROINTESTINAL", "NAUSEA",     NA,        "NR",
  "03",       12,   "NERVOUS SYSTEM",   "HEADACHE",   3,         NA,
  "04",       12,   "UNCODED",          "UNCODED",    NA,        "NOT REPORTED"
)

out3 <- SOCbyPT_Grade(
  indata       = adae2,
  dmdata       = adsl,
  group_vars   = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln   = "12",
  grade_num    = "AETOXGRN",
  grade_char   = "AETOXGR",
  sort_grade   = "NOT REPORTED",
  rtf_safe     = FALSE,
  uncoded_position = "last"
)

out3


adae_sex <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~SEX, ~AEBODSYS,          ~AEDECOD,    ~AETOXGRN,
  "01",       11,   "M",  "GASTROINTESTINAL", "NAUSEA",    2,
  "02",       11,   "F",  "GASTROINTESTINAL", "NAUSEA",    5,
  "03",       12,   "M",  "NERVOUS SYSTEM",   "HEADACHE",  3,
  "04",       12,   "F",  "NERVOUS SYSTEM",   "DIZZINESS", 1
)

adsl_sex <- tibble::tribble(
  ~USUBJID, ~TRTAN, ~SEX,
  "01",       11,   "M",
  "02",       11,   "F",
  "03",       12,   "M",
  "04",       12,   "F"
)

out4_trtN <- SOCbyPT_Grade(
  indata     = adae_sex,
  dmdata     = adsl_sex,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12",
  by_var     = "SEX",
  bigN_by    = "NO",
  print_bigN = TRUE
)

out4_byN <- SOCbyPT_Grade(
  indata     = adae_sex,
  dmdata     = adsl_sex,
  group_vars = c("TRTAN", "AEBODSYS", "AEDECOD"),
  trtan_coln = "12",
  by_var     = "SEX",
  bigN_by    = "YES",
  print_bigN = TRUE
)

out4_trtN
out4_byN

}
