% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{sm_search_scopus}
\alias{sm_search_scopus}
\title{Search Scopus Database}
\usage{
sm_search_scopus(
  query,
  max_count = 200,
  batch_size = 100,
  view = "COMPLETE",
  verbose = TRUE
)
}
\arguments{
\item{query}{Character string containing the Scopus search query. Should
follow Scopus query syntax (e.g., 'TITLE-ABS-KEY("machine learning")').}

\item{max_count}{Maximum number of papers to retrieve. Use Inf to retrieve
all available papers. Default is 200.}

\item{batch_size}{Number of records to retrieve per API call. Maximum is
100. Default is 100.}

\item{view}{Level of detail in the response. Options are "STANDARD" or
"COMPLETE". Default is "COMPLETE".}

\item{verbose}{Logical indicating whether to print progress messages.
Default is TRUE.}
}
\value{
A data.frame containing the retrieved papers with columns including
  title, abstract, author_keywords, year, DOI, and EID.
}
\description{
Retrieves abstracts and metadata from the Scopus database based on a
structured query. Handles pagination automatically and provides progress
feedback.
}
\examples{
\dontrun{
# Requires Scopus API key
sm_set_api_key()
query <- 'TITLE-ABS-KEY("sport science" AND "machine learning")'
papers <- sm_search_scopus(query, max_count = 50)
}
}
