% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{summarise_sobol}
\alias{summarise_sobol}
\title{Summarise Sobol Indices}
\usage{
summarise_sobol(result, probs = c(0.1, 0.5, 0.9), bootstrap = 200L)
}
\arguments{
\item{result}{A \code{sobol_result} object.}

\item{probs}{Numeric vector of probabilities used to report quantiles of the
empirical bootstrap distribution.}

\item{bootstrap}{Integer, number of bootstrap resamples used to quantify
the estimator uncertainty.}
}
\value{
A data frame (class \code{sobol_summary}) with the requested
statistics. Quantile columns are added when \code{probs} is not empty.
}
\description{
Compute compact summaries of the Sobol indices and their Monte Carlo
variability. The function is intended to feed diagnostic plots.
}
\examples{
design <- sobol_design(n = 64, d = 3)
model <- function(x) ishigami_model(x)
sob <- sobol_indices(model, design, keep_samples = TRUE)
summarise_sobol(sob, probs = c(0.1, 0.9))
}
