% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{safe_divide}
\alias{safe_divide}
\title{Safe Division with Zero Handling}
\usage{
safe_divide(
  numerator,
  denominator,
  zero_value = NA_real_,
  tol = .Machine$double.eps
)
}
\arguments{
\item{numerator}{Numeric vector of numerators.}

\item{denominator}{Numeric vector of denominators.}

\item{zero_value}{Value to return when denominator is effectively zero.
Default is NA.}

\item{tol}{Tolerance for considering denominator as zero. Default is
.Machine$double.eps.}
}
\value{
Numeric vector of quotients.
}
\description{
Performs division with protection against division by zero, returning
a specified value (default NA) when the denominator is zero or very small.
}
\keyword{internal}
