% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharpbound.R
\name{sharpbound}
\alias{sharpbound}
\title{Sharp bound}
\usage{
sharpbound(
  whichEst,
  sens = NULL,
  pY1_T1_S1,
  pY1_T0_S1,
  pT1_S1 = NULL,
  pT0_S1 = NULL,
  pS1_T1 = NULL,
  pS1_T0 = NULL,
  RR_UY_T1 = NULL,
  RR_UY_T0 = NULL,
  RR_SU_11 = NULL,
  RR_SU_00 = NULL,
  RR_SU_10 = NULL,
  RR_SU_01 = NULL,
  RR_UY_S1 = NULL,
  RR_TU_1 = NULL,
  RR_TU_0 = NULL
)
}
\arguments{
\item{whichEst}{Input string. Defining the causal estimand of interest.
Available options are as follows. (1) Risk ratio in the total
population: \code{"RR_tot"}, (2) Risk difference in the total population:
\code{"RD_tot"}, (3) Risk ratio in the subpopulation: \code{"RR_sub"}, (4) Risk
difference in the subpopulation: \code{"RD_sub"}.}

\item{sens}{Possible method to input sensitivity parameters. \code{sens} can
be the output from sensitivityparametersM(), a data.frame with columns
'parameter' and 'value', or a name list with correct names (e.g.
\code{"RR_UY_T1"},  \code{"RR_UY_T0"}, etc.). If not supplied, parameters can be
entered manually as specified below.}

\item{pY1_T1_S1}{Input value. The probability P(Y=1|T=1,I_S=1). Must be
between 0 and 1.}

\item{pY1_T0_S1}{Input value. The probability P(Y=1|T=0,I_S=1). Must be
between 0 and 1.}

\item{pT1_S1}{Input value. The probability P(T=1|I_S=1). Must be
between 0 and 1. Only needed for the causal estimands in the subpopulation.}

\item{pT0_S1}{Input value. The probability P(T=1|I_S=1). Must be
between 0 and 1. Only needed for the causal estimands in the subpopulation.}

\item{pS1_T1}{Input value. The probability P(I_S=1|T=1). Must be
between 0 and 1. Can be set to 0 if the value is unknown. Only needed
for the causal estimands in the total population.}

\item{pS1_T0}{Input value. The probability P(I_S=1|T=0). Must be
between 0 and 1. Can be set to 0 if the value is unknown. Only needed
for the causal estimands in the total population.}

\item{RR_UY_T1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|T=1. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_UY_T0}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|T=0. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_11}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|11. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_00}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|00. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_10}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|10. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_SU_01}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_SU|01. Must be greater than or equal to 1.
Used in the bounds for the total population.}

\item{RR_UY_S1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_UY|S=1. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}

\item{RR_TU_1}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_TU|1. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}

\item{RR_TU_0}{Possible method to input sensitivity parameter.
The sensitivity parameter RR_TU|0. Must be greater than or equal to 1.
Used in the bounds for the subpopulation.}
}
\value{
A list containing the sharp lower and upper bounds.
}
\description{
\code{sharpbound()} returns a list with the sharp bound. All sensitivity parameters for
the population of interest must be set to numbers, and the rest can be left
as \code{NULL}. The sensitivity parameters can be inserted directly or as output
from \code{sensitivityparametersM()}.
}
\examples{
# Example for risk ratio in the total population.
sharpbound(whichEst = "RR_tot", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 pS1_T1 = 0.2, pS1_T0 = 0.7, RR_UY_T1 = 2, RR_UY_T0 = 2, RR_SU_11 = 1.7, 
 RR_SU_00 = 1.5, RR_SU_10 = 2.1, RR_SU_01 = 2.3)

# Example for risk difference in the total population.
sharpbound(whichEst = "RD_tot", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 pS1_T1 = 0.2, pS1_T0 = 0.7, RR_UY_T1 = 2, RR_UY_T0 = 2, RR_SU_11 = 1.7, 
 RR_SU_00 = 1.5, RR_SU_10 = 2.1, RR_SU_01 = 2.3)

# Example for risk ratio in the subpopulation.
sharpbound(whichEst = "RR_sub", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 pT1_S1 = 0.2, pT0_S1 = 0.1, RR_UY_S1 = 2.71, RR_TU_1 = 1.91, RR_TU_0 = 2.33)

# Example for risk difference in the subpopulation.
sharpbound(whichEst = "RD_sub", pY1_T1_S1 = 0.05, pY1_T0_S1 = 0.01,
 pT1_S1 = 0.2, pT0_S1 = 0.1, RR_UY_S1 = 2.71, RR_TU_1 = 1.91, RR_TU_0 = 2.33)
 
# Example specifying the sensitivity parameters from sensitivityparametersM().
# Risk ratio in the subpopulation. DGP from the zika example.
V = matrix(c(1, 0, 0.85, 0.15), ncol = 2)
U = matrix(c(1, 0, 0.5, 0.5), ncol = 2)
Tr = c(-6.2, 1.75)
Y = c(-5.2, 5.0, -1.0)
S = matrix(c(1.2, 2.2, 0.0, 0.5, 2.0, -2.75, -4.0, 0.0), ncol = 4)
probT1 = 0.286
probT0 = 0.004
senspar = sensitivityparametersM(whichEst = "RR_sub", whichBound = "sharp",
 Vval = V,  Uval = U, Tcoef = Tr, Ycoef = Y, Scoef = S, Mmodel = "L",
 pY1_T1_S1 = probT1, pY1_T0_S1 = probT0)
 
sharpbound(whichEst = "RR_sub", sens = senspar, pY1_T1_S1 = probT1, 
 pY1_T0_S1 = probT0, pT1_S1 = 0.99, pT0_S1 = 0.01)
 

}
\references{
Zetterstrom S, Sjölander A, Waernbaum I. "Investigations of sharp bounds
for causal effects under selection bias." Statistical Methods in Medical
Research (2025).
}
