% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configure.R
\name{s_configure}
\alias{s_configure}
\title{Configure SafeMapper Settings}
\usage{
s_configure(
  batch_size = 100L,
  retry_attempts = 3L,
  auto_recover = TRUE,
  checkpoint_dir = NULL
)
}
\arguments{
\item{batch_size}{Integer. Number of items to process per batch before
checkpointing. Smaller values provide more frequent saves but may slow
processing. Default is 100.}

\item{retry_attempts}{Integer. Number of retry attempts for failed batches.
Default is 3.}

\item{auto_recover}{Logical. Whether to automatically resume from checkpoints
when restarting operations. Default is TRUE.}

\item{checkpoint_dir}{Character. Optional custom directory for storing
checkpoint files. If NULL (default), uses the standard R user cache
directory via \code{tools::R_user_dir()}.}
}
\value{
Invisible list of current configuration settings.
}
\description{
Optionally customize SafeMapper behavior. This function is NOT required
for basic usage - SafeMapper works out of the box with sensible defaults.
}
\examples{
# Basic usage - no configuration needed!
# result <- s_map(1:100, slow_function)

# Optional: customize for large operations
s_configure(batch_size = 50)

# Optional: customize for unstable operations
s_configure(retry_attempts = 5)

\donttest{
# Use custom checkpoint directory (e.g., for testing)
s_configure(checkpoint_dir = tempdir())
}

}
