% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRSplineFERInt.R
\name{SRSplineFERInt}
\alias{SRSplineFERInt}
\title{Fit a semi-parametric shape-restricted fixed effect regression spline with factor-by-curve interaction.}
\usage{
SRSplineFERInt(
  lmFormula,
  dataset,
  varNameExp,
  varNameMed,
  knotType = 2,
  preKnot = NULL,
  nBasis = 5,
  EffMain = "I",
  EffInt = "I"
)
}
\arguments{
\item{lmFormula}{A linear model formula.}

\item{dataset}{A data frame.}

\item{varNameExp}{The name of the exposure (must be a binary variable).}

\item{varNameMed}{The name of the mediator (must be a continuous variable).}

\item{knotType}{The knot type: 1=equal-spaced, 2=quantile, 3=pre-specified.}

\item{preKnot}{The pre-specified knots.}

\item{nBasis}{The number of bases.}

\item{EffMain}{The spline type for main effect}

\item{EffInt}{The spline type for interaction effect}
}
\value{
A list of knots, data set, lm model, summary of lm model, coefficient estimates of bases, covariance of coefficient estimates of bases, projected coefficient estimates, test statistic.
}
\description{
Fit a semi-parametric shape-restricted fixed effect regression spline with factor-by-curve interaction.
}
\keyword{internal}
