% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datamanagement.R
\name{pre_comput_nothing}
\alias{pre_comput_nothing}
\title{pre_comput_nothing: Precompute quantities for SLGP basis evaluation without interpolation}
\usage{
pre_comput_nothing(
  normalizedData,
  predictorNames,
  responseName,
  nIntegral = 101
)
}
\arguments{
\item{normalizedData}{A data frame with values already normalized to \eqn{[0,1]}.}

\item{predictorNames}{Character vector of covariate column names.}

\item{responseName}{Name of the response variable.}

\item{nIntegral}{Integer, number of points used to discretize the response domain.}
}
\value{
A list of intermediate quantities used in SLGP basis function computation:
\itemize{
\item \code{nodes}: all points where basis functions are evaluated,
\item \code{indNodesToIntegral}: index mapping nodes to response bins,
\item \code{indSamplesToNodes}: index mapping observations to nodes,
\item \code{indSamplesToPredictor}: index mapping observations to unique predictors,
\item \code{weightSamplesToNodes}: interpolation weights (equal to 1 here).
}
}
\description{
Computes intermediate quantities for evaluating basis functions when no interpolation
is used. Basis functions are evaluated at the exact covariate and response grid locations.
}
\keyword{internal}
