% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{puma_atlanticr}
\alias{puma_atlanticr}
\title{Occurrence records of \emph{Puma concolor} from AtlanticR}
\format{
A data frame where each row represents a single occurrence record of
\emph{Puma concolor}. Columns include species name, location, and other
relevant metadata fields provided by the \code{atlantic_mammals} dataset.
}
\usage{
puma_atlanticr
}
\description{
A subset of Atlantic mammals records obtained from the
\code{atlanticr::atlantic_mammals} dataset, containing occurrences of
\emph{Puma concolor}.

This dataset is provided as an example to illustrate how to create
user-defined metadata templates for occurrence records from external
sources using the package’s \code{create_metadata()} function.
}
\examples{
# Preview first rows
head(puma_atlanticr)

# Count occurrences per year
table(puma_atlanticr$year)


}
\seealso{
\code{create_metadata()},
\code{format_columns()}
}
\keyword{datasets}
