% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_gbif_download.R
\name{prepare_gbif_download}
\alias{prepare_gbif_download}
\title{Prepare data to request GBIF download}
\usage{
prepare_gbif_download(
  species,
  rank = NULL,
  kingdom = NULL,
  phylum = NULL,
  class = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  strict = FALSE,
  progress_bar = FALSE,
  ...
)
}
\arguments{
\item{species}{(character) a vector of species name(s).}

\item{rank}{(character) optional taxonomic rank (for example, 'species' or
'genus'). Default is NULL, meaning it will return species matched across all
ranks.}

\item{kingdom}{(character) optional taxonomic kingdom (for example, 'Plantae'
or 'Animalia'). Default is NULL, meaning it will return species matched
across all kingdoms.}

\item{phylum}{(character) optional taxonomic phylum. Default is NULL, meaning
it will return species matched across all phyla.}

\item{class}{(character) optional taxonomic class. Defaults is NULL, meaning
it will return species matched across all classes.}

\item{order}{(character) optional taxonomic order. Defaults is NULL, meaning
it will return species matched across all orders}

\item{family}{(character) optional taxonomic family. Defaults is NULL,
meaning it will return species matched across all families.}

\item{genus}{(character) optional taxonomic genus. Defaults is NULL, meaning
it will return species matched across all genus.}

\item{strict}{(logical) If TRUE, it (fuzzy) matches only the given name, but
never a taxon in the upper classification. Default is FALSE.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{...}{other parameters passed to \code{rgbif::occ_count()}.}
}
\value{
A data.frame with species information, including the number of occurrences
and other related details.
}
\description{
Prepare data to request GBIF download
}
\note{
This function requires an active internet connection to access GBIF data.
}
\examples{
\donttest{
gbif_prepared <- prepare_gbif_download(species = "Araucaria angustifolia")
}
}
